//
//  AHKABArrayController.h
//  AH-K3001V Address Utility
//
//  Created by FUJIDANA on Sat Apr 16 2005.
//  Copyright (c) 2005 FUJIDANA. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "AHKUniquelyNumberedArrayController.h"

extern NSString	*AHKABRowIndexesPboardType;
//extern NSString *AHKABPeoplePboardType;

@class AHKABMainWindowController;

@interface AHKABArrayController : AHKUniquelyNumberedArrayController {
	IBOutlet	AHKABMainWindowController	*mainWindowController;
    IBOutlet	NSTableView					*contentTableView;
	IBOutlet	NSSearchField				*searchField;
	
				NSString					*oldSearchString;
				int							searchFilterTag;
}

#pragma mark override methods
- (void)awakeFromNib;

#pragma mark methods for search
- (IBAction)search:(id)sender;
- (NSString *)searchString;
- (void)setSearchString:(NSString *)value;

- (IBAction)selectSearchFilters:(id)sender;
- (int)searchFilterTag;
- (void)setSearchFilterTag:(int)value;
- (NSArray *)searchFilterKeys;

// - (void)insertObject:(id)object atArrangedObjectIndex:(unsigned int)index;
// - (NSArray *)arrangeObjects:(NSArray *)objects;

//#pragma mark utility methods
//- (void)restoreArrangementAndSelection;

@end

#pragma mark -
@interface AHKABArrayController (Dragging)
- (void)registerTableViewForDraggedTypes;
@end

